<?php 
/**
 * Add admin menu panel.
 *
 * @subpackage Goblog Free
 * @since Goblog Free 1.0
 */

/**
 * Add theme page menu.
 */
function goblog_free_add_menu_theme_page() {
    add_theme_page( 'goblog_free', 'Goblog Free', 'edit_theme_options', 'goblog_free', 'goblog_free_admin_menu_html' );
}
add_action( 'admin_menu', 'goblog_free_add_menu_theme_page' );

/**
 * Add theme page HTML.
 */
function goblog_free_admin_menu_html() { 
?>
    <div class="wrap">
        <h2><?php echo __('Information', 'goblog-free'); ?></h2>

        <ul>
            <li><?php echo __('Theme Name: Goblog Free', 'goblog-free'); ?></li>
            <li><?php echo __('Theme URI: https://goblog.gothemeshop.com/free/', 'goblog-free'); ?></li>
            <li><?php echo __('Author: Yuky Hendiawan', 'goblog-free'); ?></li>
            <li><?php echo __('Author URI: https://hendky.com', 'goblog-free'); ?></li>
            <li><?php echo __('Version: 3.1.0', 'goblog-free'); ?></li>
            <li><?php echo __('Requires PHP: 7.0', 'goblog-free'); ?></li>
            <li><?php echo __('License: GNU General Public License v3 or later', 'goblog-free'); ?></li>
            <li><?php echo __('License URI: https://www.gnu.org/licenses/gpl-3.0.html', 'goblog-free'); ?></li>
        </ul>

        <h2><?php echo __('Documentation', 'goblog-free'); ?></h2>
        <p><?php echo __('You can read more complete documentation at: ', 'goblog-free' ); ?><a rel="noreferrer noopener" href="https://gothemeshop.com/goblog-free-theme-documentation/" target="_blank"><?php echo __('link documentation', 'goblog-free'); ?></a></p>
    </div>
<?php 
}